<?php
require_once 'config.php';
verificarLogin();

$titulo = "Dashboard";

// Verificar segurança da sessão
if ($_SESSION['user_agent'] !== $_SERVER['HTTP_USER_AGENT'] || 
    $_SESSION['ip_address'] !== $_SERVER['REMOTE_ADDR']) {
    session_unset();
    session_destroy();
    header("Location: login.php?security=1");
    exit();
}

// Estatísticas DO USUÁRIO ATUAL
$stmt = $pdo->prepare("SELECT COUNT(*) as total FROM clientes WHERE usuario_id = ?");
$stmt->execute([$_SESSION['usuario_id']]);
$total_clientes = $stmt->fetch()['total'];

$stmt = $pdo->prepare("SELECT COUNT(*) as total FROM clientes WHERE status = 'ativo' AND usuario_id = ?");
$stmt->execute([$_SESSION['usuario_id']]);
$clientes_ativos = $stmt->fetch()['total'];

$stmt = $pdo->prepare("SELECT COUNT(*) as total FROM planos WHERE usuario_id = ?");
$stmt->execute([$_SESSION['usuario_id']]);
$total_planos = $stmt->fetch()['total'];

$proximos_vencimento = clientesProximosVencimento($pdo, 3);

// Clientes próximos do vencimento
$stmt = $pdo->prepare("
    SELECT c.*, p.nome as plano_nome 
    FROM clientes c 
    JOIN planos p ON c.plano_id = p.id 
    WHERE c.data_vencimento <= DATE_ADD(CURDATE(), INTERVAL 3 DAY) 
    AND c.status = 'ativo' 
    AND c.usuario_id = ?
    ORDER BY c.data_vencimento ASC 
    LIMIT 5
");
$stmt->execute([$_SESSION['usuario_id']]);
$clientes_proximos = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo; ?> - Gestor DREEYTV</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        :root {
            --primary: #667eea;
            --secondary: #2d3748;
            --success: #48bb78;
            --warning: #ed8936;
            --danger: #f56565;
        }
        
        body {
            background: #f5f7fa;
            color: #2d3748;
        }
        
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 280px;
            background: var(--secondary);
            color: white;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: rgba(0,0,0,0.2);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h2 {
            font-size: 1.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .sidebar-menu li {
            margin: 5px 15px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover {
            background: rgba(255,255,255,0.1);
            color: white;
        }
        
        .sidebar-menu a.active {
            background: var(--primary);
            color: white;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
        }
        
        .header {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            font-size: 1.8rem;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            text-align: center;
            border-left: 4px solid var(--primary);
        }
        
        .stat-icon {
            font-size: 3rem;
            margin-bottom: 15px;
        }
        
        .stat-number {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #666;
            font-weight: 600;
        }
        
        .content-section {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
        }
        
        .section-header h2 {
            color: var(--secondary);
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 20px;
            background: var(--primary);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-danger {
            background: var(--danger);
        }
        
        .table-container {
            overflow-x: auto;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
        }
        
        th {
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        
        td {
            padding: 15px;
            border-bottom: 1px solid #e2e8f0;
        }
        
        tr:hover {
            background: #f8fafc;
        }
        
        .status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .status-danger {
            background: #fed7d7;
            color: #742a2a;
        }
        
        .status-warning {
            background: #feebcb;
            color: #744210;
        }
        
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }
        
        .empty-state .icon {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .security-badge {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: var(--success);
            color: white;
            padding: 10px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        @media (max-width: 768px) {
            .admin-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .section-header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .security-badge {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>📺 GESTOR DREEYTV</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="index.php" class="active">📊 Dashboard</a></li>
                <li><a href="clientes/clientes.php">👨‍💼 Clientes</a></li>
                <li><a href="planos/planos.php">📋 Planos</a></li>
                <li><a href="servidores/servidores.php">🖥️ Servidores</a></li>
                <?php if ($_SESSION['usuario_tipo'] == 'admin'): ?>
                    <li><a href="usuarios/usuarios.php">👥 Usuários</a></li>
                <?php endif; ?>
                <li><a href="senha/alterar_senha.php">🔑 Alterar Senha</a></li>
                <li><a href="logout.php">🚪 Sair</a></li>
            </ul>
        </div>
        
        <div class="main-content">
            <div class="header">
                <h1>📊 Dashboard</h1>
                <div class="user-info">
                    <div class="user-avatar"><?php echo substr($_SESSION['usuario_nome'], 0, 1); ?></div>
                    <div>
                        <div style="font-weight: 600;"><?php echo $_SESSION['usuario_nome']; ?></div>
                        <div style="font-size: 0.9rem; color: #666;"><?php echo ucfirst($_SESSION['usuario_tipo']); ?></div>
                    </div>
                    <a href="logout.php" class="btn" style="background: var(--danger);">🚪 Sair</a>
                </div>
            </div>
            
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon">👨‍💼</div>
                    <div class="stat-number"><?php echo $total_clientes; ?></div>
                    <div class="stat-label">Total de Clientes</div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">✅</div>
                    <div class="stat-number"><?php echo $clientes_ativos; ?></div>
                    <div class="stat-label">Clientes Ativos</div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">📋</div>
                    <div class="stat-number"><?php echo $total_planos; ?></div>
                    <div class="stat-label">Planos Cadastrados</div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">⏰</div>
                    <div class="stat-number"><?php echo $proximos_vencimento; ?></div>
                    <div class="stat-label">Vencem em 3 Dias</div>
                </div>
            </div>
            
            <div class="content-section">
                <div class="section-header">
                    <h2>⏰ Clientes Próximos do Vencimento</h2>
                    <a href="clientes/clientes.php" class="btn">👁️ Ver Todos</a>
                </div>
                
                <?php if (!empty($clientes_proximos)): ?>
                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Cliente</th>
                                    <th>Plano</th>
                                    <th>Vencimento</th>
                                    <th>Dias Restantes</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($clientes_proximos as $cliente): ?>
                                    <?php
                                    $data_vencimento = new DateTime($cliente['data_vencimento']);
                                    $hoje = new DateTime();
                                    $dias_restantes = $hoje->diff($data_vencimento)->days;
                                    
                                    if ($data_vencimento < $hoje) {
                                        $status_class = 'status-danger';
                                        $status_text = 'Vencido';
                                    } else {
                                        $status_class = 'status-warning';
                                        $status_text = 'Próximo';
                                    }
                                    ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo htmlspecialchars($cliente['nome']); ?></strong>
                                            <div style="font-size: 0.8rem; color: #666;"><?php echo htmlspecialchars($cliente['telefone']); ?></div>
                                        </td>
                                        <td><?php echo htmlspecialchars($cliente['plano_nome']); ?></td>
                                        <td>
                                            <strong><?php echo date('d/m/Y', strtotime($cliente['data_vencimento'])); ?></strong>
                                        </td>
                                        <td>
                                            <?php echo $dias_restantes; ?> dias
                                        </td>
                                        <td>
                                            <span class="status-badge <?php echo $status_class; ?>">
                                                <?php echo $status_text; ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="empty-state">
                        <div class="icon">🎉</div>
                        <h3 style="color: var(--secondary); margin-bottom: 10px;">Nenhum vencimento próximo</h3>
                        <p>Todos os clientes estão com suas assinaturas em dia!</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="security-badge">
        🔒 Sistema Seguro
    </div>
</body>
</html>